﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using ArcheBuddy.Bot.Classes;


namespace AutoExp.Quests
{
    //
    internal class Quest_1070 : Quest
    {
        public Quest_1070 (int minLvl, int maxLvl, QuestRace race, uint[] reqQuests)
            : base(1070, minLvl, maxLvl, race, reqQuests)
        { }

        public override bool RunQuest(Host host)
        {
            if (!base.RunQuest(host))
                return false;

            if (!checkQuestCompletedOrPerfomed(1076))
                return false;

            if (getQuest() == null)
            {
                if (!host.movementModule.GpsMove("Tiger_MissingAdventurer")) return false;
                Thread.Sleep(1000);
                host.StartQuest(id);
                Thread.Sleep(1000);
            }

            ArcheBuddy.Bot.Classes.Quest quest = getQuest();

            if (quest != null && quest.status == QuestStatus.Accepted)
            {
                Zone zone = new RoundZone(21076.40, 8114.84, 70);
                if (!zone.ObjInZone(host.me))
                    if (!host.movementModule.GpsMove("Tiger_MissingAdventurer")) return false;
                host.farmModule.SetFarmMobs(zone, new uint[] { 3355 });
                while (host.farmModule.farmState == Modules.FarmState.Enabled && quest.status == QuestStatus.Accepted)
                    Thread.Sleep(100);
                host.farmModule.StopFarm();
                Thread.Sleep(1000);
            }

            if (quest != null && quest.status == QuestStatus.Performed)
            {
                if (!host.movementModule.GpsMove("Tiger_MissingAdventurer")) return false;
                host.CompleteQuest(id, 3);
                Thread.Sleep(1000);
            }

            return true;
        }
    }
}
